//
//	Class definition for the Game State
//
//	- uses ldwGameState as base class
//

#ifndef THE_GAME_STATE_H
#define THE_GAME_STATE_H

#include "ldwGameState.h"
#include "ldwGameWindow.h"
#include "ldwEventManager.h"
#include "ldwScene.h"
#include "FoodStore.h"
#include "GameStats.h"
#include "GameTime.h"
#include "Isola.h"
#include "Tech.h"
#include "TechPoints.h"
#include "../Achievements/Achievement.h"
#include "../Collectables/CollectableItem.h"
#include "../Sound/SoundTrack.h"
#include "../TutorialTips/TutorialTip.h"
#include "../Utils/theStringManager.h"
#include "../Villagers/VillagerManager.h"
#include "../Villagers/Graveyard.h"
#include "../World/WorldMap.h"



struct PopupMessageRequestType
{
	StringId	whatMessage;
	EGameScene	m_eWhatScene;
};

typedef enum  
{
	eResultNULL,
	eNoRestart,
	eYesRestart

} ResultTypeEnum;

#define MAX_PLAYER_NAME_LENGTH 20
#define quickRefreshInterval	40 //seconds

//puzzle prerequisite defines
#define hospitalMedicineReq		3
#define hospitalBuildingReq		2

#define clothingHutCultureReq	2
#define clothingHutScienceReq	2

const int GameState_c_iMaxPuzzleDataSize = 4 * 1024;


//STUFF THAT IS SAVED IN THE SAVEFILE
struct theGameData
{
	WorldStateType worldState[maxNumGameStates + 1];	//TODO: remove this - replaced with Puzzle class above

	CAchievement::SSaveState		m_sAchievementSaveState;
	CCollectableItem::SSaveState	m_sCollectableItemSaveState;
	CFoodStore::SSaveState			m_sFoodStoreSaveState;
	CGameStats::SSaveState			m_sGameStatsSaveState;
	CGameTime::SSaveState			m_sGameTimeSaveState;
	CGraveyard::SSaveState			m_sGraveyardSaveState;
	CTech::SSaveState				m_sTechSaveState;
	CTechPoints::SSaveState			m_sTechPointsSaveState;
	CTutorialTip::SSaveState		m_sTutorialTipSaveState;
	CVillager::SSaveState			m_sVillagerSaveState[VillagerManager_c_iMaxVillagers];

	unsigned char					m_uiPuzzleData[GameState_c_iMaxPuzzleDataSize];


	char playerName[MAX_PLAYER_NAME_LENGTH + 1];
	ldwUINT32 scoreID;

	int saveSlotVersion;

	ldwUINT32 crisisTimer;

	ldwUINT32 chiefTimerCollectibles;
	ldwUINT32 chiefTimerTeach;
	ldwUINT32 chiefTimerFood;

	ldwUINT32 lastTimeChecked;

	int difficulty;

	bool playTrack[eSoundTrack_NumberOf];

	float soundVol;
	float musicVol;
	float voiceoverVol;

	int minutesPerAge;
};


enum GameSaveSlotEnum
{
	GameSaveSlotNULL,
	GameSaveSlot1,
	GameSaveSlot2,
	GameSaveSlot3,
	GameSaveSlot4,
	GameSaveSlot5
};

struct theGameInfo 
{
	GameSaveSlotEnum currentSaveSlot;
	GameSaveSlotEnum priorSaveSlot;

	bool registered;
	bool fullscreen;

	char player1Name[MAX_PLAYER_NAME_LENGTH + 1];
	char player2Name[MAX_PLAYER_NAME_LENGTH + 1];
	char player3Name[MAX_PLAYER_NAME_LENGTH + 1];
	char player4Name[MAX_PLAYER_NAME_LENGTH + 1];
	char player5Name[MAX_PLAYER_NAME_LENGTH + 1];

	bool player1SaveSlotActive;
	bool player2SaveSlotActive;
	bool player3SaveSlotActive;
	bool player4SaveSlotActive;
	bool player5SaveSlotActive;

	int saveVersion;

	bool saveGameFileLoadError; //- true when loading save game file has errors (i.e. missing file, etc) 

	ldwUINT32 firstStartTime;
	ldwUINT32 firstRegTime;
};

class theGameState : public theGameData, public theGameInfo, public ldwGameState
{
public:

	enum
	{
		eGameInfoSlot     = 0,
		ePlayer1GameSlot,
		ePlayer2GameSlot,
		ePlayer3GameSlot,
		ePlayer4GameSlot,
		ePlayer5GameSlot,
		eRegGameSlot     = 11
    };

	static theGameState * Create();	
	static theGameState * Get();
	static void Destroy();

	int clothingChoiceRequest;
	int clothingConfirmRequest;

	bool gameIsCatchingUp;

	~theGameState();

	const char* GetGameTitle();
	const char*	GetGameName();

	EGameScene m_eCurrentGameScene;
	void SetCurrentGameScene(EGameScene eWhichScene) { m_eCurrentGameScene = eWhichScene; };	

	int  GetCurrentGameScene() {return m_eCurrentGameScene;}

	ResultTypeEnum dialogResult;

	int GetGameWindowWidth();
	int GetGameWindowHeight();
	int GetBitsPerPixel();

	int CountSpiritualityRating();

	bool StartWindowed();
	void Load();

	bool Load(int slot);
	bool Save(int slot);

	bool SaveCurrentGame();
	bool LoadCurrentGame();

	void AutoSaveGame();

	void RemoveGameFile(int slot);


	long GetStatRealGameHoursThisGame();
	int PlayerNeedsCorrection();

	int focus; // which villager in focus
	int lastFocus;

	//PALM GLOBALS
	ldwUINT32 UPDATETIMER;
	ldwUINT32 QUICKREFRESHTIMER;

	void Init();
	void RestartCurrentGame();

	void InitGameInfo();

protected:

	void InitOptions();

	theGameState();

	ldwUINT32 mAutoSaveTimer;
};

#endif
